#!/bin/sh

# Change current directory to the parent of this script file
cd $(dirname $0)

tar -xf openjdk-25.0.1_macos-x64_bin.tar.gz
unzip openjfx-25.0.1_osx-x64_bin-jmods.zip 

export JAVA_HOME="jdk-25.0.1.jdk/Contents/Home"
export PATH_TO_FX_MODS="javafx-jmods-25.0.1"

$JAVA_HOME/bin/jlink --module-path $PATH_TO_FX_MODS \
    --add-modules java.base,java.desktop,java.xml,javafx.base,javafx.graphics,javafx.swing \
    --bind-services --output ../jre_macos \
    --add-options="'--enable-native-access=javafx.graphics' '--sun-misc-unsafe-memory-access=allow'"

cp README.html ../jre_macos